;----------------------------------------------------------------------------
; Flash Games
; Flash Player Projector v10.3.183.7
; by djvj
; 1.1
;
; Notes:
; If you want a game to go fullscreen, define it in the Setting.ini
;----------------------------------------------------------------------------

settingsFile := checkFile(A_WorkingDir . "\Modules\" . systemName . "\Settings.ini")
IniRead, loadingScreen, %settingsFile%, Settings, LoadingScreen
IniRead, fullscreen, %settingsFile%, %romName%, Fullscreen

; This gets rid of the emu window that pops up on launch
If ( loadingScreen = "true" ) {
		Gui +AlwaysOnTop -Caption +ToolWindow
		Gui Color, Black
		Gui Show, x0 y0 h%A_ScreenHeight% w%A_ScreenWidth%
	}

SetControlDelay, 50
Run, %executable%, %emuPath%
WinWait, AHK_class ShockwaveFlash
Send, ^o ; Open File
WinWait, AHK_class #32770
ControlSetText, Edit1, %romPath%%romName%%romExtension%, AHK_class #32770
ControlSend, Button1, {Enter}, AHK_class #32770

WinSet, Style, -0xC00000, AHK_class ShockwaveFlash ; Removes the titlebar of the game window
WinSet, Style, -0x40000, AHK_class ShockwaveFlash ; Removes the border of the game window
DllCall("SetMenu", uint, WinActive( "A" ), uint, 0) ; Removes the MenuBar

; Go Fullscreen
If ( fullscreen = "true" ) {
		Sleep, 500
		Send, ^f
		Sleep, 500
	} Else
		Center(AHK_class ShockwaveFlash)

Gui Destroy

Process, WaitClose, %executable%

ExitApp

Center(title) {
		WinGetPos, x, y, width, height, %title%
		x := ( A_ScreenWidth / 2 ) - ( width / 2 )
		y := ( A_ScreenHeight / 2 ) - ( height / 2 )
		WinMove, %title%, , x, y
	}

ScriptError(error) {
		Gui Destroy
		MsgBox,48,Error,%error%,5
		ExitApp
	}

CheckFile(file) {
		IfNotExist, %file%
		{
			ScriptError("Cannot find " . file)
			ExitApp
		}
		return %file%
	}

CloseProcess:
	WinClose, AHK_class ShockwaveFlash
Return